
<h1><?php echo $title ?></h1>

<p>
    <a href="?controller=product&action=create" class="btn btn-success" title="Přidat produkt">
        <i class="bi bi-plus"></i>
    </a>
</p>
<div class="table-responsive rounded-3 overflow-hidden">
    <table class="table table-dark table-striped mb-0">
        <thead>
            <tr>
                <th scope="col">ID</th>
                <th scope="col">Název</th>
                <th scope="col">Kategorie</th>
                <th scope="col">Cena</th>
                <th scope="col">Skladem</th>
                <th scope="col">Dodavatel</th>
               <th scope="col" class="text-end">Akce</th> </tr>

            </tr>
        </thead>
        <tbody>
        <?php foreach($products as $p): ?>
            <tr>
                <td><?=htmlspecialchars($p->id)?></td>
                <td><?=htmlspecialchars($p->name)?></td>
                <td><?=htmlspecialchars($p->category)?></td>
                <td><?=number_format((float)$p->price, 2, ',', ' ')?></td>
                <td><?=htmlspecialchars($p->stock)?></td>
                <td><?=htmlspecialchars($p->supplier_name ?? '-')?></td>
                <td class="text-end">
                    <a href="?controller=product&action=show&id=<?= $p->id ?>" class="btn btn-primary"><i class="bi bi-eye"></i></a>
                    <a href="?controller=product&action=edit&id=<?= $p->id ?>" class="btn btn-light"><i class="bi bi-pencil"></i></a>
                    <a href="?controller=product&action=delete&id=<?= $p->id ?>" onclick="return confirm('Opravdu smazat?')" class="btn btn-danger"><i class="bi bi-trash"></i></a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
